REM ****** AFRAC.BAS
' This program was made by
'                              Alfred D'Attore
'
'                           Compuserve 75222,1254
'
'                                     or
'
'                         1300 South Farm View Drive
'                               Apartment B-21
'                            Dover, Delaware 19904
'                                     USA
'
' Modified by Tomohumi Kodama.
'
REM ***  Auto Fractal.  Space Bar for quick change in picture.
'                       Any other key to exit to DOS.
DEFINT I-K, M, Q
DECLARE SUB Init ()
DECLARE FUNCTION KeyScan ()
DECLARE SUB DispMode ()
DECLARE SUB ResetVideo ()
'
Init
DIM a(16), b(16), c(16), d(16), e(16), f(16)
RANDOMIZE TIMER
maxcol = 650
maxrow = 485
SCREEN 12
'
restart:   REM **** Start new fractal
quit = 0
r = 0:
dx = 180!: dy = 180!: zx = 16: zy = 12: REM Initparms, screen set
rr = INT(RND * 15) + 1: REM * Begin color
DO WHILE r = 0 OR r = rr
  r = INT(RND * 16)
LOOP
REM * End color
j = INT(RND * 15) + 2
sx = 230!: sy = 180!: lx = 230!: ly = 180!: REM Initparms, frac set
REM * Begin Random gen of fractal parms, translations, rotations, etc
a(1) = .3 - .6 * RND
b(1) = .7 - .3 * RND
c(1) = -.9 + .7 * RND
d(1) = .7 - .99 * RND
e(1) = 5! - 13! * RND
f(1) = 10! - 8! * RND
a(2) = .7 - .5 * RND
b(2) = .8 - .3 * RND
c(2) = .7 - .4 * RND
d(2) = -.5 + .2 * RND
e(2) = 6! - 3! * RND
f(2) = 15! - 30! * RND
k = INT(RND * 2)
IF k = 0 THEN
  a(1) = -a(1): a(2) = -a(2)
  b(1) = -b(1): b(2) = -b(2)
  c(1) = -c(1): c(2) = -c(2)
  d(1) = -d(1): d(2) = -d(2)
  e(1) = -e(1): e(2) = -e(2)
END IF
'
ko = INT(RND * 4)
FOR k = 3 TO j
  a(k) = .7 - .3 * RND
  b(k) = .7 - .3 * RND
  c(k) = -.7 + .3 * RND
  d(k) = .7 - .3 * RND
  e(k) = 15! - 6! * RND
  f(k) = 15! - 6! * RND
  IF ko = 0 THEN
      IF k <= j / 2 THEN
	c(k) = -c(k)
	d(k) = -d(k)
      END IF
    ELSEIF ko = 2 THEN
      a(k) = -a(k)
      b(k) = -b(k)
      c(k) = -c(k)
      d(k) = -d(k)
  END IF
NEXT
'
REM *** End random parameters generation
t! = TIMER + (12 * RND * ABS(c(1))) + 3
FOR k = 1 TO 15
  PALETTE k, INT(RND * 64) + INT(RND * 64) * 256 + INT(RND * 64) * 65536
NEXT
REM **** Begin fractal generation
x = 0!: y = 0!
FOR q = 0 TO 12000
  k = INT(RND * 2) + 1
  newx = a(k) * x + b(k) * y + e(k)
  newy = c(k) * x + d(k) * y + f(k)
  x = newx
  y = newy
  IF q = 10 THEN
      sx = newx
      sy = newy
      lx = newx
      ly = newy
    ELSEIF q > 10 AND q < 100 THEN
      IF newx < sx THEN sx = newx
      IF newx > lx THEN lx = newx
      IF newy < sy THEN sy = newy
      IF newy > ly THEN ly = newy
    ELSEIF q > 99 THEN
      IF k = 1 THEN
	  ko = r
	ELSE
	  ko = rr
      END IF
      PSET (dx + zx * newx, dy + zy * newy), ko
      IF t! < TIMER THEN
	  EXIT FOR
	ELSE
	  quit = KeyScan
	  IF quit <> 0 THEN EXIT FOR
      END IF
  END IF
  FOR k = 3 TO j
    nextx = a(k) * newx + b(k) * newy + e(k)
    nexty = c(k) * newx + d(k) * newy + f(k)
    newx = nextx: newy = nexty
    ko = 18 - k
    IF q > 99 THEN PSET (dx + zx * newx, dy + zy * newy), ko
    IF q > 10 AND q < 100 THEN
      IF nextx < sx THEN sx = nextx
      IF nextx > lx THEN lx = nextx
      IF nexty < sy THEN sy = nexty
      IF nexty > ly THEN ly = nexty
    END IF
  NEXT
  IF q = 99 THEN
    zx = maxcol / (lx - sx)
    zy = maxrow / (ly - sy)
    dx = .5 * maxcol - zx * (lx + sx) / 2!
    dy = .5 * maxrow - zy * (ly + sy) / 2!
  END IF
NEXT
CLS
REM End *** fractal generation
IF quit = &H39 OR quit = 0 THEN GOTO restart
PALETTE
ResetVideo
DispMode
SYSTEM

